## Overview of VPN User and Site Configuration

- VPNs connect remote users or sites to a protected network over an untrusted transport network.
- Security policies may be complex due to different user groups with varying requirements.
- A flexible and scalable configuration method is essential for managing these policies.

---

## Configuration Requirements

- **Customizable Settings:**
    - Ability to apply network and security settings to specific users, groups, or sites.
- **Policy Modularity:**
    - Configure similar policies for different groups.
    - Allow small exceptions without duplicating work.
    - Use modularity and inheritance in configuration hierarchies.

---

## Cisco Secure Firewall ASA & Threat Defense Approach

- Separates access methods from policies for flexibility and scalability.

### Major Configuration Constructs

- **Connection Profiles:**
    - Define authentication and protocol-specific parameters (pre-login requirements).
- **Group Policies:**
    - Reusable sets of attribute-value pairs for post-login settings and security policies.

---

## Configuration Philosophy

- Consistent approach for all major VPN access methods:
    - Full-tunnel SSL VPNs
    - Clientless SSL VPNs
    - Full-tunnel VPNs
- **User Classification:**
    - Remote users are classified into a connection profile (determines authentication).
    - After authentication, group policy settings are applied (post-login).

---

## Benefits of Separation

- **Flexibility:**
    - Apply access settings and security policies to any user or group.
- **Scalability:**
    - No duplication when configuring similar policies.
    - Achieved through modularity and hierarchical inheritance.

---

## Modularity and Inheritance in Group Policies

- **Default Group Policy:**
    - Every system has a default (DfltGrpPolicy).
    - Other policies inherit non-explicitly defined values from this default.
- **Custom Group Policies:**
    - Example: Employees-Policy inherits defaults but adds employee-specific settings.
    - Additional group policies can be created for special user requirements.

---

## Sources of User Attributes for VPN Sessions

- **Dynamic Access Policy (DAP) Rules:**
    - Configure authorization based on dynamic/static events (e.g., client authentication, client posture).
- **Local User Database:**
    - Attributes can be set per user profile on the Cisco Secure Firewall ASA.
- **Group Policy on VPN Device:**
    - Defined on the device and can be assigned in two ways:
        - **User Account Assignment:** Set in the local database or pushed from AAA server (user-specific).
        - **Connection Profile Assignment:** Applied to all users using that profile (group-specific).

---

## Attribute Assignment Order

1. Attributes from local user database or AAA server.
2. Attributes in group policy attached to user account or pushed from AAA server.
3. Attributes in group policy attached to the connection profile.
4. Attributes in the default group policy.

---